%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate7_Main.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This runs the project for 7 sensor colors
%--------------------------------------------------------------------------
close all; clear all; clc;
warning('OFF');

Recover = false;         % Used if the simulation has been interrupted and
                         % we need to pick up where we left off
if(Recover)
    load Simulate7Data.mat;
    load Simulate7_sensorIndex.mat;
    load SavedData7;
    load SensorData7.mat;
else
    % Generate all the sensor data that we will be using in SensorData5.mat
    GenSensorData7; clear all; 
    load SensorData7.mat
   
    NumRows = size(sensorSettings,1);       % Number of different sensors that we're running
    colorMetrics = zeros(NumRows,1);        % Initialize vector to save color metrics            
    noiseMetrics = zeros(NumRows,1);        % Initialize vector to save noise metrics
    frequencyMetrics = zeros(NumRows,1);    % Initialize vector to save frequency metrics

    sensorIndex = 1;
    analysisIndex = 1;
    save('SavedData7.mat','colorMetrics','noiseMetrics','frequencyMetrics','sensorIndex','analysisIndex');
end


% Loop through all the sensors
Simulate7_Sub;


% Put the results into a matrix that we can save
%--------------------------------------------------------
ResultNames7 = sensorSettings_Names;
Results7 = sensorSettings;

Results7 = [Results7 colorMetrics frequencyMetrics noiseMetrics]; 
ResultNames7 = {ResultNames7{:},'deltaE','MTF50','yNoise'};


% Display the results
disp(ResultNames7);
disp(Results7);

% Save the final results
save('Results_7.mat', 'ResultNames7', 'Results7');

% Plot the final results

colors = ['r', 'g', 'b', 'y', 'c', 'm', 'k'];
figure(1);
plot(frequencyMetrics, colorMetrics, 'bo');
xlabel('MTF-50');
ylabel('Average \Delta E');
title('\bfColor Accuracy vs Frequency Accuracy, 7 colors');
grid on;
axis([0 max(1.2*frequencyMetrics) 0 max(1.2*colorMetrics)]);

saveas(gcf, ['./Images/Results_7.png']);






